import { world, system, BlockPermutation, ItemStack } from '@minecraft/server'

world.afterEvents.playerBreakBlock.subscribe(data => {
    const block = data.block
    const player = data.player
    const { x, y, z } = block.location
    const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
    const destroyedBlock = data.brokenBlockPermutation.type.id
    const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe')
    const itemRose = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:rose_block.name', closest: 1 })
    const itemBlueberry = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:blueberry_bush.name', closest: 1 })
    const itemMuppetEgg = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:muppet_egg_block.name', closest: 1 })
    const itemTabiloEgg = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:tabilo_egg_block.name', closest: 1 })
    const itemSunflower = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:growing_sunflower.name', closest: 1 })
    const itemGlowingMushroom = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:glowing_mushroom.name', closest: 1 })
    const itemHangingBlueMushroom = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:hanging_blue_mushroom.name', closest: 1 })
    const itemInfectedGrass = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:infected_grass.name', closest: 1 })
    const itemPurpleMushroom = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:purple_mushroom.name', closest: 1 })
    const itemShroomblossom = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:shoomblossom.name', closest: 1 })
    const itemGarnet = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:garnet.name', closest: 1 })
    const itemGargot = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:gargot.name', closest: 1 })
    const itemTallGargot = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:tall_gargot.name', closest: 1 })
    const itemGarpite = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:garpite.name', closest: 1 })
    const itemEndMushroom = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:end_mushroom_block.name', closest: 1 })
    const itemEndGrass = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:end_grass_block.name', closest: 1 })
    const itemBlueBonnetsBlock = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:blue_bonnets_block.name', closest: 1 })
    const itemBlueBonnetsGrowing = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:blue_bonnets_growing.name', closest: 1 })
    const itemBlueBonnetsWaxed0 = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:blue_bonnets_waxed0.name', closest: 1 })
    const itemBlueBonnetsWaxed1 = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:blue_bonnets_waxed1.name', closest: 1 })
    const itemAraucariaSapling = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:araucaria_sapling_block.name', closest: 1 })
    const itemSmallCitrineBud = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:small_citrine_bud_block.name', closest: 1 })
    const itemMediumCitrineBud = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:medium_citrine_bud_block.name', closest: 1 })
    const itemLargeCitrineBud = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:large_citrine_bud_block.name', closest: 1 })
    const itemCitrineCluster = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:citrine_cluster_block.name', closest: 1 })
    if (!selectedItem) return
    else if (!selectedItem.hasComponent('enchantable')) return
    else if (player.getGameMode === 'creative') return
    else if (isPickaxe && player.getGameMode() !== "creative" && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch') && destroyedBlock === 'v360:citrine_cluster_block') {
        block.dimension.runCommand(`loot spawn ${x} ${y} ${z} loot citrine_cluster1`)
    }
    else if (!isPickaxe && player.getGameMode() !== "creative" && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch') && (destroyedBlock === 'v360:garnet' || destroyedBlock === 'v360:gargot' || destroyedBlock === 'v360:tall_gargot')) return
    if (isPickaxe && player.getGameMode() !== "creative" && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch') && (destroyedBlock === 'v360:garnet' || destroyedBlock === 'v360:gargot' || destroyedBlock === 'v360:tall_gargot')) {
        block.dimension.runCommand(`loot spawn ${x} ${y} ${z} loot garnet`)
    }
    else if (player.getGameMode() !== 'creative' && selectedItem && selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
        if (destroyedBlock === 'v360:rose_block') {
            itemRose[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:rose', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:blueberry_bush') {
            itemBlueberry[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:blueberries', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:muppet_egg_block') {
            itemMuppetEgg[0].kill()
        }
        else if (destroyedBlock === 'v360:tabilo_egg_block') {
            itemTabiloEgg[0].kill()
        }
        else if (destroyedBlock === 'v360:growing_subflower') {
            itemSunflower[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:sunflower_seeds', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:glowing_mushroom') {
            itemGlowingMushroom[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:glowing_mushroom_item', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:hanging_blue_mushroom') {
            itemHangingBlueMushroom[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:hanging_blue_mushroom_item', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:purple_mushroom') {
            itemPurpleMushroom[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:purple_mushroom_item', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:infected_grass') {
            itemInfectedGrass[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:infected_grass_item', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:shoomblossom') {
            itemShroomblossom[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:shroomblossom_item', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (isPickaxe && destroyedBlock === 'v360:garnet') {
            itemGarnet[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:garnet_cluster', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (isPickaxe && destroyedBlock === 'v360:gargot') {
            itemGargot[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:gargot_item', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (isPickaxe && destroyedBlock === 'v360:garpite') {
            itemGarpite[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:garpite_item', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (isPickaxe && destroyedBlock === 'v360:tall_gargot') {
            itemTallGargot[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:tall_gargot_item', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:end_mushroom_block') {
            itemEndMushroom[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:end_mushroom', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:end_grass_block') {
            itemEndGrass[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:end_grass', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:blue_bonnets_block') {
            itemBlueBonnetsBlock[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:blue_bonnets', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:blue_bonnets_growing') {
            itemBlueBonnetsGrowing[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:blue_bonnets_seeds', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:blue_bonnets_waxed0') {
            itemBlueBonnetsWaxed0[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:blue_bonnets_seeds', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (destroyedBlock === 'v360:blue_bonnets_waxed1') {
            itemBlueBonnetsWaxed1[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:blue_bonnets_seeds', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
        }
        else if (isPickaxe && destroyedBlock === 'v360:small_citrine_bud_block') {
            itemSmallCitrineBud[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:small_citrine_bud'), block.center())
        }
        else if (isPickaxe && destroyedBlock === 'v360:medium_citrine_bud_block') {
            itemMediumCitrineBud[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:medium_citrine_bud'), block.center())
        }
        else if (isPickaxe && destroyedBlock === 'v360:large_citrine_bud_block') {
            itemLargeCitrineBud[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:large_citrine_bud'), block.center())
        }
        else if (isPickaxe && destroyedBlock === 'v360:citrine_cluster_block') {
            itemCitrineCluster[0].kill()
            block.dimension.spawnItem(new ItemStack('v360:citrine_cluster'), block.center())
        }
    }
})

world.afterEvents.playerBreakBlock.subscribe(data => {
    const block = data.block
    const player = data.player
    const { x, y, z } = block.location
    const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
    const destroyedBlock = data.brokenBlockPermutation.type.id
    const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe')
    if (!isPickaxe && player.getGameMode() !== 'creative' && destroyedBlock === 'v360:citrine_cluster_block') {
        block.dimension.runCommand(`loot spawn ${x} ${y} ${z} loot citrine_cluster0`)
    }
})